% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{grow}
\alias{grow}
\title{Estimate a topic model}
\usage{
grow(
  x,
  iterations = 100,
  nChains = 1,
  nCores = 1,
  displayProgress = TRUE,
  computeLikelihood = TRUE,
  seed = NULL
)
}
\arguments{
\item{x}{a model created with the \code{\link[=LDA]{LDA()}}, \code{\link[=JST]{JST()}} or \code{\link[=rJST]{rJST()}} function}

\item{iterations}{the number of iterations by which the model should be grown}

\item{nChains}{if set above 1, the model will be grown into multiple chains
from various starting positions. Latent variables will be re-initialized if
\code{x} has not been grown before.}

\item{nCores}{if \code{nChains} is greater than 1, this allows to compute the the
multiple chains in a parallel setting}

\item{displayProgress}{if \code{TRUE}, a progress bar will be displayed indicating
the progress of the computation. Disabled when \code{nChains} is greater than 1.}

\item{computeLikelihood}{boolean. If set to FALSE, does not compute the
likelihood at each iteration. This can slightly decrease the computing
time.}

\item{seed}{for reproducibility, a seed can be provided}
}
\value{
a \code{sentopicmodel} of the relevant model class if \code{nChains} is
unspecified or equal to 1. A \code{multiChains} object if \code{nChains} is greater
than 1.
}
\description{
This function is used to estimate a topic model created by
\code{\link[=LDA]{LDA()}}, \code{\link[=JST]{JST()}} or \code{\link[=rJST]{rJST()}}. In essence, this function
iterates a Gibbs sampler MCMC.
}
\examples{
model <- rJST(ECB_press_conferences_tokens)
grow(model, 10)
}
\seealso{
\code{\link[=LDA]{LDA()}}, \code{\link[=JST]{JST()}}, \code{\link[=rJST]{rJST()}}, \code{\link[=reset]{reset()}}
}
\author{
Olivier Delmarcelle
}
