% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sobol_boot.R
\name{sobol_ci}
\alias{sobol_ci}
\title{Bootstrap confidence intervals for Sobol' indices.}
\usage{
sobol_ci(b, params, type, conf, second = FALSE, third = FALSE)
}
\arguments{
\item{b}{The output of the \code{sobol_indices} function.}

\item{params}{A vector with the name of the model inputs.}

\item{type}{A vector of character strings representing
the type of intervals required. The value should be any subset
of the values \code{c("norm", "basic", "perc", "bca")}. For more information,
check the function \code{\link{boot.ci}}.}

\item{conf}{A scalar or vector containing the confidence
level(s) of the required interval(s).}

\item{second}{Logical. If \code{second = TRUE}, it computes the confidence
intervals for second-order indices. Default is \code{second = FALSE}.}

\item{third}{Logical. If \code{third = TRUE}, it computes the confidence
intervals for third-order indices. Default is \code{third = FALSE}.}
}
\value{
A data table.
}
\description{
It computes bootstrap confidence intervals for Sobol' indices.
}
\examples{
# Define settings:
n <- 1000; k <- 8; R <- 100
# Design the sample matrix:
A <- sobol_matrices(n = n, k = k, second = TRUE, third = TRUE)
# Compute the model output:
Y <- sobol_Fun(A)
# Compute the Sobol' indices:
\donttest{sens <- sobol_indices(Y = Y, params = colnames(data.frame(A)),
R = R, n = n, parallel = "no", ncpus = 1,
second = TRUE, third = TRUE)
# Compute confidence intervals:
sobol_ci(sens, params = colnames(data.frame(A)), type = "norm", conf = 0.95)}
}
\seealso{
\code{\link{boot}}, \code{\link{boot.ci}}.
}
