% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_crs2.R
\name{st_crs2}
\alias{st_crs2}
\title{Retrieve coordinate reference system from sf or sfc object}
\usage{
st_crs2(x, ...)
}
\arguments{
\item{x}{numeric, character, or object of class \link{sf} or \link{sfc}, being:
\itemize{
\item EPSG code: numeric (e.g. \code{32632}) or character (in the form
\code{"32632"} or \code{"EPSG:32632"});
\item UTM zone: numeric (e.g. \code{32}, interpreted as 32 North) or character
(e.g. \code{"32"} or \code{"32N"} for zone 32 North, \code{"32S"} for 32 South);
\item WKT test: passed as character string or as path of a text file
containing it (e.g. the path of a .prj file);
\item PROJ.4 string, passed as character (e.g.
\code{"+proj=utm +zone=32 +datum=WGS84 +units=m +no_defs"}
(\strong{NOTE}: this representation is deprecated with PROJ >= 6
-- see http://rgdal.r-forge.r-project.org/articles/PROJ6_GDAL3.html --
so a warning is returned using it, unless the string contains only
the epsg code -- e.g. \code{"+init=epsg:32632"}, in which case the EPSG
code is taken);
\item path of a spatial file (managed by \link[sf:st_read]{sf::st_read} or \link[stars:read_stars]{stars::read_stars}),
passed as character string of length 1;
\item spatial file of class \link{sf} or \link{sfc}.
}}

\item{...}{other parameters passed to \link[sf:st_crs]{sf::st_crs}.}
}
\value{
An object of class \link{crs} of length 2.
}
\description{
This function is a wrapper for \link[sf:st_crs]{sf::st_crs}, unless
threating numeric \code{character} strings as integers, and
accepting also UTM timezones, paths of spatial files and paths of
text files containing WKT like .prj (see details) .
}
\details{
See \link[sf:st_crs]{sf::st_crs} for details.
}
\note{
License: GPL 3.0
}
\examples{
## CRS from EPSG
st_crs2(32609)
st_crs2("EPSG:32609")

## CRS from UTM zone
st_crs2(9)
st_crs2("09")
st_crs2("9N")
st_crs2("09S")

## CRS from WKT (string or path)
(wkt_32n <- sf::st_as_text(sf::st_crs(32609)))
st_crs2(wkt_32n)
writeLines(wkt_32n, wkt_32n_path <- tempfile())
st_crs2(wkt_32n_path)

## CRS from spatial file path
raster_path <- system.file(
  "extdata/out/S2A2A_20190723_022_Barbellino_BOA_10.tif", 
  package="sen2r"
)
vector_path <- system.file(
  "extdata/vector/barbellino.geojson", 
  package="sen2r"
)
st_crs2(raster_path)
st_crs2(vector_path)

## CRS from spatial files
st_crs2(stars::read_stars(raster_path))
st_crs2(sf::read_sf(vector_path))

\donttest{
## CRS from PROJ.4 string
# (avoid using this with PROJ >= 6!)
st_crs2("+init=epsg:32609") # this makes use of the EPSG code
st_crs2("+proj=utm +zone=9 +datum=WGS84 +units=m +no_defs")
st_crs2(raster::raster(raster_path)) # st_crs(raster) uses the PROJ.4 as input
}
}
\references{
L. Ranghetti, M. Boschetti, F. Nutini, L. Busetto (2020).
"sen2r": An R toolbox for automatically downloading and preprocessing
Sentinel-2 satellite data. \emph{Computers & Geosciences}, 139, 104473.
\doi{10.1016/j.cageo.2020.104473}, URL: \url{https://sen2r.ranghetti.info/}.
}
\author{
Luigi Ranghetti, phD (2019) \email{luigi@ranghetti.info}
}
