% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s2_thumbnails.R
\name{raster2rgb}
\alias{raster2rgb}
\title{Produce an RGB image from a singleband raster file.}
\usage{
raster2rgb(
  in_rast,
  out_file = NULL,
  palette = "generic_ndsi_2",
  minval = -1,
  maxval = 1,
  bigtiff = FALSE,
  tmpdir = NA
)
}
\arguments{
\item{in_rast}{Path of the input multiband raster.}

\item{out_file}{(optional) Path of the output RGB JPEG image; if NULL
(default), a RasterLayer will be returned.}

\item{palette}{Path of the palette file to be used (cpt or txt),
or character value of a builtin palette ("SCL", "NDVI", the default
"generic_ndsi" or "generic_ndsi_2").}

\item{minval}{(to be implemented) the value corresponding to the minimum
value of the palette (for now, only -1 is used). A quantile will be also
accepted.}

\item{maxval}{(to be implemented) the value corresponding to the maximum
value of the palette (for now, only 1 is used). A quantile will be also
accepted.}

\item{bigtiff}{(optional) Logical: if TRUE, the creation of a BigTIFF is
forced (default is FALSE).
This option is used only in the case a GTiff format was chosen.}

\item{tmpdir}{(optional) Path where intermediate files (VRT) will be created.
Default is a temporary directory.
If \code{tmpdir} is a non-empty folder, a random subdirectory will be used.}
}
\value{
The path of the output image; alternatively, the output image
as RasterLayer (if \code{out_rast = NULL}).
}
\description{
Internal function to create JPEG or PNG images from a
singleband raster file. This function is used by \link{s2_thumbnails},
and it will be exported when it would be more generalised.
}
\note{
License: GPL 3.0
}
\references{
L. Ranghetti, M. Boschetti, F. Nutini, L. Busetto (2020).
"sen2r": An R toolbox for automatically downloading and preprocessing
Sentinel-2 satellite data. \emph{Computers & Geosciences}, 139, 104473.
\doi{10.1016/j.cageo.2020.104473}, URL: \url{https://sen2r.ranghetti.info/}.
}
\author{
Luigi Ranghetti, phD (2019) \email{luigi@ranghetti.info}
}
