% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_utils.R
\name{boot_paths_df}
\alias{boot_paths_df}
\title{Return all path bootstraps as a long dataframe.
Columns of the dataframes are specified paths and rows are the estimated
coefficients for the paths at each bootstrap iteration.}
\usage{
boot_paths_df(pls_boot)
}
\arguments{
\item{pls_boot}{bootstrapped PLS model}
}
\description{
Return all path bootstraps as a long dataframe.
Columns of the dataframes are specified paths and rows are the estimated
coefficients for the paths at each bootstrap iteration.
}
\examples{
data(mobi)

mobi_mm <- constructs(
  composite("Image",        multi_items("IMAG", 1:5)),
  composite("Expectation",  multi_items("CUEX", 1:3)),
  composite("Satisfaction", multi_items("CUSA", 1:3))
)

mobi_sm <- relationships(
  paths(from = c("Image", "Expectation"), to = "Satisfaction")
)

pls_model <- estimate_pls(data = mobi,
                          measurement_model = mobi_mm,
                          structural_model = mobi_sm)

pls_boot <- bootstrap_model(seminr_model = pls_model,
                            nboot = 50, cores = 2, seed = NULL)

boot_paths_df(pls_boot)

}
