% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/actions.R
\name{actions_scroll}
\alias{actions_scroll}
\title{Scroll the page}
\usage{
actions_scroll(x, y, delta_x, delta_y, duration = NULL, origin = "viewport")
}
\arguments{
\item{x}{The x coordinate from which the scroll action originates from.}

\item{y}{The y coordinate from which the scroll action originates from.}

\item{delta_x}{The number of pixels to scroll in the x direction.}

\item{delta_y}{The number of pixels to scroll in the y direction.}

\item{duration}{The duration of the scroll, in seconds.}

\item{origin}{The point from which \code{x} and \code{y} are measured. Can be a
\code{WebElement} object, in which case \code{x} and \code{y} are measured from the
center of the element. Otherwise, \code{origin} must be \code{"viewport"}.}
}
\value{
A \code{selenium_action} object.
}
\description{
Scroll actions to be passed into \code{\link[=actions_stream]{actions_stream()}}. Scroll the page in
a given direction.
}
\examples{
actions_stream(
  actions_scroll(x = 1, y = 1, delta_x = 1, delta_y = 1, duration = 0.5)
)

}
