% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{elem_name}
\alias{elem_name}
\title{Get the tag name of an element}
\usage{
elem_name(x, timeout = NULL)
}
\arguments{
\item{x}{A \code{selenider_element} object.}

\item{timeout}{The time to wait for \code{x} to exist.}
}
\value{
A string.
}
\description{
Get the tag name (e.g. \code{"p"} for a \verb{<p>} tag) of a \code{selenider_element}
object.
}
\examples{
\dontshow{if (selenider::selenider_available(online = FALSE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
html <- "
<div class='mydiv'></div>
"
session <- minimal_selenider_session(html)

s(".mydiv") |>
  elem_name()
\dontshow{\}) # examplesIf}
}
\seealso{
Other properties: 
\code{\link{elem_attr}()},
\code{\link{elem_css_property}()},
\code{\link{elem_size}()},
\code{\link{elem_text}()}
}
\concept{properties}
