% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equal.R
\name{elem_equal}
\alias{elem_equal}
\alias{==.selenider_element}
\title{Are two elements equivalent?}
\usage{
elem_equal(x, y, timeout = NULL)

\method{==}{selenider_element}(e1, e2)
}
\arguments{
\item{x, y, e1, e2}{\code{selenider_element} objects to compare.}

\item{timeout}{How long to wait for the elements to be present.}
}
\value{
\code{TRUE} or \code{FALSE}.
}
\description{
Checks if two \code{selenider_element} objects point to the
same element on the page. \code{elem_equal()} is equivalent to
using \code{==}, but allows you to specify a timeout value if
needed.
}
\examples{
\dontshow{if (selenider::selenider_available(online = FALSE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
html <- "
<div></div>
<div class='second'>
  <p></p>
</div>
"

session <- minimal_selenider_session(html)

s("div") == ss("div")[[1]]

has_p_child <- function(x) {
  x |>
    elem_children() |> # Direct children
    elem_filter(has_name("p")) |>
    has_at_least(1)
}

ss("div") |>
  elem_find(has_p_child) |>
  elem_equal(s(".second")) # TRUE
\dontshow{\}) # examplesIf}
}
\seealso{
\itemize{
\item \code{\link[=elem_filter]{elem_filter()}} and \code{\link[=elem_find]{elem_find()}} for filtering collection of elements.
}
}
