## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(segtest)

## -----------------------------------------------------------------------------
o1 <- multidog_to_g(ufit, type = "all_g", p1 = "indigocrisp", p2 = "sweetcrisp")
o2 <- multidog_to_g(ufit, type = "all_gl", p1 = "indigocrisp", p2 = "sweetcrisp")

## -----------------------------------------------------------------------------
o3 <- multidog_to_g(ufit2, type = "off_g")
o4 <- multidog_to_g(ufit2, type = "off_gl")
o5 <- multidog_to_g(ufit3, type = "off_g")
o6 <- multidog_to_g(ufit3, type = "off_gl")

## -----------------------------------------------------------------------------
future::availableCores()

## -----------------------------------------------------------------------------
future::plan(future::multisession(workers = 2))
mout <- multi_lrt(g = o2$g, p1 = o2$p1, p2 = o2$p2)
future::plan(future::sequential())

## -----------------------------------------------------------------------------
mout[c("snp", "p_value")]

## -----------------------------------------------------------------------------
o1$g["2_20070837", ]
o1$p1["2_20070837"]
o1$p2["2_20070837"]

## -----------------------------------------------------------------------------
offspring_gf_2(alpha = 0.1249, xi1 = 1/3, p1 = 2, p2 = 0)
o1$g["12_31029646", ] / sum(o1$g["12_31029646", ])
o1$p1["12_31029646"]
o1$p2["12_31029646"]

