% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.compare_parameters.R
\name{plot.see_compare_parameters}
\alias{plot.see_compare_parameters}
\title{Plot method for comparison of model parameters}
\usage{
\method{plot}{see_compare_parameters}(
  x,
  show_intercept = FALSE,
  size_point = 0.8,
  size_text = NA,
  dodge_position = 0.8,
  sort = NULL,
  n_columns = NULL,
  show_labels = FALSE,
  ...
)
}
\arguments{
\item{x}{An object.}

\item{show_intercept}{Logical, if \code{TRUE}, the intercept-parameter is included
in the plot. By default, it is hidden because in many cases the
intercept-parameter has a posterior distribution on a very different
location, so density curves of posterior distributions for other parameters
are hardly visible.}

\item{size_point}{Numeric specifying size of point-geoms.}

\item{size_text}{Numeric value specifying size of text labels.}

\item{dodge_position}{Numeric value specifying the amount of "dodging"
(spacing) between geoms.}

\item{sort}{The behavior of this argument depends on the plotting contexts.
\itemize{
\item \emph{Plotting model parameters}:
If \code{NULL}, coefficients are plotted in the order as they appear in the
summary. Setting \code{sort = "ascending"} or \code{sort = "descending"} sorts
coefficients in ascending or descending order, respectively.
Setting \code{sort = TRUE} is the same as \code{sort = "ascending"}.
\item \emph{Plotting Bayes factors}:
Sort pie-slices by posterior probability (descending)?
}}

\item{n_columns}{For models with multiple components (like fixed and random,
count and zero-inflated), defines the number of columns for the
panel-layout. If \code{NULL}, a single, integrated plot is shown.}

\item{show_labels}{Logical. If \code{TRUE}, text labels are displayed.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A ggplot2-object.
}
\description{
The \code{plot()} method for the \code{parameters::compare_parameters()}
function.
}
\examples{
data(iris)
lm1 <- lm(Sepal.Length ~ Species, data = iris)
lm2 <- lm(Sepal.Length ~ Species + Petal.Length, data = iris)
lm3 <- lm(Sepal.Length ~ Species * Petal.Length, data = iris)
result <- parameters::compare_parameters(lm1, lm2, lm3)
plot(result)
}
