% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.check_homogeneity.R
\name{plot.see_check_homogeneity}
\alias{plot.see_check_homogeneity}
\title{Plot method for homogeneity of variances checks}
\usage{
\method{plot}{see_check_homogeneity}(x, data = NULL, ...)
}
\arguments{
\item{x}{An object.}

\item{data}{The original data used to create this object. Can be a
statistical model.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A ggplot2-object.
}
\description{
The \code{plot()} method for the \code{performance::check_homogeneity()}
function.
}
\examples{
library(performance)

model <<- lm(len ~ supp + dose, data = ToothGrowth)
result <- check_homogeneity(model)
result
plot(result)

}
