% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/completeness.R
\name{form_status_counts}
\alias{form_status_counts}
\title{A function to assess the status of forms}
\usage{
form_status_counts(object, ...)
}
\arguments{
\item{object}{\code{secuTrialdata} object}

\item{...}{further parameters}
}
\value{
data.frame informing on the status of saved forms per participant
}
\description{
This function returns a data.frame informing on the status of saved
forms per participant. There is a line for every combination of
form type and participant id. The numbers are occurrence counts.
}
\examples{
# prepare path to example export
export_location <- system.file("extdata", "sT_exports", "snames",
                               "s_export_CSV-xls_CTU05_short_ref_miss_en_utf8.zip",
                               package = "secuTrialR")
# load all export data
sT_export <- read_secuTrial(data_dir = export_location)

# get form status
form_status_counts(sT_export)

}
\keyword{completeness}
\keyword{form}
\keyword{status}
