\name{capthist.parts}
\alias{animalID}
\alias{occasion}
\alias{trap}
\alias{alive}
\alias{xy}
\alias{alongtransect}
\alias{unmarked}
\alias{signal}
\alias{xy<-}
\alias{unmarked<-}
\alias{signal<-}
%% \alias{times}
%% \alias{times<-}

\title{ Dissect Spatial Capture History Object }

\description{
  Extract parts of an object of class 'capthist'.
}

\usage{

animalID(object, names = TRUE)
occasion(object)
trap(object, names = TRUE)
alive(object)
alongtransect(object, tol = 0.01)
xy(object)
xy(object) <- value
signal(object)
signal(object) <- value
unmarked(object)
unmarked(object) <- value
%% times(object)
%% times(object) <- value

}

\arguments{

  \item{object}{ a 'capthist' object }
  \item{names}{ if FALSE the values returned are numeric indices rather
    than names }
  \item{tol}{ tolerance for snapping to transect line (m) }
  \item{value}{ replacement value (see Details) }

}
\details{

These functions extract data on detections, ignoring occasions when an
animal was not detected. Detections are ordered by occasion, animalID
and trap.

\code{trap} returns polygon or transect numbers if \code{traps(object)}
has detector type 'polygon' or 'transect'.

\code{alongtransect} returns the distance of each detection from the
start of the transect with which it is associated.

Replacement values must precisely match \code{object} in number of
detections and in their order. \code{xy<-} expects a dataframe of x and y
coordinates for points of detection within a 'polygon' or 'transect'
detector.

\code{unmarked} extracts or replaces the counts of unmarked animals that
are saved as attribute `Tu' of \code{object}.
}

\value{
For \code{animalID} and \code{trap} a vector of numeric or character values, one per detection.

For \code{alive} a vector of logical values, one per detection.

For \code{occasion}, a vector of numeric values, one per detection.

For \code{xy}, a dataframe with one row per detection and columns 'x' and 'y'.

For \code{unmarked}, a matrix with one row per detector and one column
for each occasion. The number of occasions should match the number of
columns in \code{object} (noting that \code{object} has no rows).

%%For \code{signal} and \code{times}, a numeric vector with one element per detection.
For \code{signal}, a numeric vector with one element per detection.

If \code{object} has multiple sessions, the result is a list with one
component per session.

}

\seealso{ \code{\link{capthist}}, \code{\link{polyID}} }

\examples{

## 'captdata' is a demonstration dataset
animalID(captdata)

temp <- sim.capthist(popn=list(D=1), make.grid(detector='count'))
cbind(ID=as.numeric(animalID(temp)), occ=occasion(temp), trap=trap(temp))

}

\keyword{ manip }

