% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nearestcorr.R
\name{nearcorr}
\alias{nearcorr}
\title{Nearest Correlation Matrix Problem}
\usage{
nearcorr(H)
}
\arguments{
\item{H}{A symmetric matrix}
}
\value{
\item{X}{A list containing the solution matrix to the primal problem}
\item{y}{A list containing the  solution vector to the dual problem}
\item{Z}{A list containing the  solution matrix to the dual problem}
\item{pobj}{The achieved value of the primary objective function}
\item{dobj}{The achieved value of the dual objective function}
}
\description{
\code{nearcorr} creates input for sqlp to solve the nearest correlation matrix problem -
given a approximate correlation matrix H, find the nearest correlation matrix X.
}
\details{
For a given approximate correlation matrix H, determines the nearest correlation matrix X. 
Mathematical and implementation details can be found in the vignette
}
\examples{
data(Hnearcorr)

out <- nearcorr(Hnearcorr)

}
