% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeProblem.R
\name{makeProblem}
\alias{makeProblem}
\title{Create a problem instance}
\usage{
makeProblem(
  data,
  dimList,
  dimVarInd = NULL,
  freqVarInd = NULL,
  numVarInd = NULL,
  weightInd = NULL,
  sampWeightInd = NULL
)
}
\arguments{
\item{data}{a data frame featuring at least one column for each desired
dimensional variable. Optionally the input data can feature variables
that contain information on cell counts, weights that should be used during
the cut and branch algorithm, additional numeric variables or variables that
hold information on sampling weights.}

\item{dimList}{a (named) list where the names refer to variable names in
input \code{data}. If the list is not named, it is required to specify argument
\code{dimVarInd}. Each list element can be one of:
\itemize{
\item \code{tree}: generated with \verb{hier_*()} functions from package \code{sdcHierarchies}
\item \code{data.frame}: a two column \code{data.frame} containing the full hierarchy of
a dimensional variable using a top-to-bottom approach. The format of this
\code{data.frame} is as follows:
\itemize{
\item \strong{first column:} a character vector specifying levels with each vector
element being a string only containing of \code{@}s from length 1 to n.
If a vector element consists of \code{i}-chars, the corresponding code
is of level \code{i}. The code \code{@} (one character) equals the grand
total (level=1), the code \verb{@@} (two characters) is of level 2 (directly
below the overall total).
\item \strong{second column:} a character vector specifying level codes
}
\item \code{path}: absolute or relative path to a \code{.csv} file that
contains two columns seperated by semicolons (\verb{;}) having the same structure
as the \code{"@;levelname"}-structure described above
}}

\item{dimVarInd}{if \code{dimList} is a named list, this argument is
ignored (\code{NULL}). Else either a numeric or character vector
defining the column indices or names of dimensional variables
(specifying the table) within argument \code{data} are expected.}

\item{freqVarInd}{if not \code{NULL}, a scalar numeric or character vector
defining the column index or variable name of a variable holding counts
in \code{data}}

\item{numVarInd}{if not \code{NULL}, a numeric or character vector
defining the column indices or variable names of additional numeric
variables with respect to \code{data}}

\item{weightInd}{if not \code{NULL}, a scalar numeric or character vector
defining the column index or variable name holding costs within \code{data}
that should be used as objective coefficients when solving secondary
cell suppression problems.}

\item{sampWeightInd}{if not \code{NULL}, a scalar numeric or character vector
defining the column index or variable name of a variable holding sampling
weights within \code{data}. In case a complete table is provided, this parameter is
ignored.}
}
\value{
a \linkS4class{sdcProblem} object
}
\description{
Function \code{\link[=makeProblem]{makeProblem()}} is used to create \linkS4class{sdcProblem} objects.
}
\examples{
# loading micro data
data("microData1", package="sdcTable")
# having a look at the data structure
str(microData1)

# we can observe that we have a micro data set consisting
# of two spanning variables ('region' and 'gender') and one
# numeric variable ('val')

# specify structure of hierarchical variable 'region'
# levels 'A' to 'D' sum up to a Total
dim.region <- data.frame(
 levels=c('@','@@','@@','@@','@@'),
 codes=c('Total', 'A','B','C','D'),
 stringsAsFactors=FALSE)

# specify structure of hierarchical variable 'gender'
# using create_node() and add_nodes() (see ?manage_hierarchies)
dim.gender <- hier_create(root = "Total", nodes = c("male", "female"))
hier_display(dim.gender)

# create a named list with each element being a data-frame
# containing information on one dimensional variable and
# the names referring to variables in the input data
dimList <- list(region = dim.region, gender = dim.gender)

# third column containts a numeric variable
numVarInd <- 3

# no variables holding counts, numeric values, weights or sampling
# weights are available in the input data
# creating an problem instance using numeric indices
p1 <- makeProblem(
  data = microData1,
  dimList = dimList,
  numVarInd = 3 # third variable in `data`
)

# using variable names is also possible
p2 <- makeProblem(
  data = microData1,
  dimList = dimList,
  numVarInd = "val"
)

# what do we have?
print(class(p1))

# have a look at the data
df1 <- sdcProb2df(p1, addDups = TRUE,
  addNumVars = TRUE, dimCodes = "original")
df2 <- sdcProb2df(p2, addDups=TRUE,
  addNumVars = TRUE, dimCodes = "original")
print(df1)

identical(df1, df2)
}
\author{
Bernhard Meindl
}
