% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/generics_cutList.r, R/methods_class_cutList.r
\docType{methods}
\name{calc.cutList}
\alias{calc.cutList}
\alias{calc.cutList,cutList,character,list-method}
\title{perform calculations on \code{cutList}-objects depending on argument \code{type}}
\usage{
calc.cutList(object, type, input)

\S4method{calc.cutList}{cutList,character,list}(object, type, input)
}
\arguments{
\item{object}{an object of class \code{cutList}}

\item{type}{a character vector of length 1 defining what to calculate|return|modify. Allowed types are:}
\itemize{
\item strengthen: strenghten constraints in argument \code{object}
\item checkViolation: check if a given solution violates any in argument \code{object}
\item bindTogether: combine two \code{cutList}-objects}

\item{input}{a list depending on argument \code{type}.}

\itemize{
\item type==strengthen: input is not used (empty list)
\item type==checkViolation: input is a list of length 2
\itemize{
\item first element: numeric vector specifying a solution to a linear problem
\item second element: numeric vector specifying weights}
\item type==bindTogether: input is a list of length 1
\itemize{
\item first element: object of class \code{cutList} }}
}
\value{
manipulated data based on argument \code{type}
\itemize{
\item an object of class \code{cutList} if argument \code{type} matches 'strengthen' or 'bindTogether'
\item a logical vector of length 1 if argument \code{type} matches 'checkViolation' with TRUE if at least one constraint is violated by the given solution
}
}
\description{
perform calculations on \code{cutList}-objects depending on argument \code{type}
}
\note{
internal function
}
\author{
Bernhard Meindl \email{bernhard.meindl@statistik.gv.at}
}

