% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataGen.r
\docType{methods}
\name{dataGen}
\alias{dataGen}
\title{Fast generation of synthetic data}
\usage{
dataGen(obj, ...)
}
\arguments{
\item{obj}{an \code{\link{sdcMicroObj-class}}-object or a \code{data.frame}}

\item{...}{see possible arguments below
\itemize{
\item{n}{amount of observations for the generated data}}}
}
\value{
the generated synthetic data.
}
\description{
Fast generation of (primitive) synthetic multivariate normal data.
}
\details{
Uses the cholesky decomposition to generate synthetic data with approx. the
same means and covariances.  For details see at the reference.
}
\note{
With this method only multivariate normal distributed data with
approxiomately the same covariance as the original data can be generated
without reflecting the distribution of real complex data, which are, in
general, not follows a multivariate normal distribution.
}
\examples{
data(mtcars)
cov(mtcars[,4:6])
cov(dataGen(mtcars[,4:6]))
pairs(mtcars[,4:6])
pairs(dataGen(mtcars[,4:6]))

## for objects of class sdcMicro:
data(testdata2)
sdc <- createSdcObj(testdata2,
  keyVars=c('urbrur','roof','walls','water','electcon','relat','sex'),
  numVars=c('expend','income','savings'), w='sampling_weight')
sdc <- dataGen(sdc)
}
\references{
Have a look at
\url{https://web.archive.org/web/20110906030928/http://crises2-deim.urv.cat/docs/publications/lncs/443.pdf}
}
\seealso{
\code{\link{sdcMicroObj-class}}, \code{\link{shuffle}}
}
\author{
Matthias Templ
}
\keyword{manip}
