% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printFunctions.R
\name{freq}
\alias{freq}
\title{Freq}
\usage{
freq(obj, type = "fk")
}
\arguments{
\item{obj}{an \code{\link{sdcMicroObj-class}}-object}

\item{type}{either \code{'fk'} or \code{'FK'}}
}
\value{
a vector containing sample frequencies or weighted frequencies
}
\description{
Extract sample frequency counts (fk) or estimated population frequency counts (Fk)
}
\examples{
data(testdata)
sdc <- createSdcObj(testdata,
  keyVars=c('urbrur','roof','walls','relat','sex'),
  pramVars=c('water','electcon'),
  numVars=c('expend','income','savings'), w='sampling_weight')
head(freq(sdc, type="fk"))
head(freq(sdc, type="Fk"))
}

