% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_functions.r
\docType{methods}
\name{extractManipData}
\alias{extractManipData}
\alias{extractManipData,sdcMicroObj-method}
\alias{extractManipData-methods}
\title{Remove certain variables from the data set inside a sdc object.}
\usage{
extractManipData(obj, ignoreKeyVars = FALSE, ignorePramVars = FALSE,
  ignoreNumVars = FALSE, ignoreGhostVars = FALSE, ignoreStrataVar = FALSE)
}
\arguments{
\item{obj}{object of class \code{\link{sdcMicroObj-class}}}

\item{ignoreKeyVars}{If manipulated KeyVariables should be returned or the
unchanged original variables}

\item{ignorePramVars}{If manipulated PramVariables should be returned or the
unchanged original variables}

\item{ignoreNumVars}{If manipulated NumericVariables should be returned or
the unchanged original variables}

\item{ignoreGhostVars}{If manipulated Ghost (linked) Variables should be returned or
the unchanged original variables}

\item{ignoreStrataVar}{If manipulated StrataVariables should be returned or
the unchanged original variables}
}
\value{
a data frame
}
\description{
Extract the manipulated data from an object of class \code{\link{sdcMicroObj-class}}
}
\section{Methods}{
 \describe{
\item{list("signature(obj = \"sdcMicroObj\")")}{}}
}
\examples{

## for objects of class sdcMicro:
data(testdata2)
sdc <- createSdcObj(testdata,
  keyVars=c('urbrur','roof'),
  numVars=c('expend','income','savings'), w='sampling_weight')
sdc <- removeDirectID(sdc, var="age")
dataM <- extractManipData(sdc)

}
\author{
Alexander Kowarik, Bernhard Meindl
}
\keyword{methods}

