% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualise.R
\name{plot.sdbuildR_sim}
\alias{plot.sdbuildR_sim}
\title{Plot timeseries of simulation}
\usage{
\method{plot}{sdbuildR_sim}(
  x,
  add_constants = FALSE,
  vars = NULL,
  palette = "Dark 2",
  colors = NULL,
  font_family = "Times New Roman",
  font_size = 16,
  wrap_width = 25,
  showlegend = TRUE,
  ...
)
}
\arguments{
\item{x}{Output of simulate().}

\item{add_constants}{If TRUE, include constants in plot. Defaults to FALSE.}

\item{vars}{Variables to plot. Defaults to NULL to plot all variables.}

\item{palette}{Colour palette. Must be one of hcl.pals().}

\item{colors}{Vector of colours. If NULL, the color palette will be used. If specified, will override palette. The number of colours must be equal to the number of variables in the simulation data frame. Defaults to NULL.}

\item{font_family}{Font family. Defaults to "Times New Roman".}

\item{font_size}{Font size. Defaults to 16.}

\item{wrap_width}{Width of text wrapping for labels. Must be an integer. Defaults to 25.}

\item{showlegend}{Whether to show legend. Must be TRUE or FALSE. Defaults to TRUE.}

\item{...}{Optional parameters}
}
\value{
Plotly object
}
\description{
Visualize simulation results of a stock-and-flow model. Plot the evolution of stocks over time, with the option of also showing other model variables.
}
\examples{
sfm <- xmile("SIR")
sim <- simulate(sfm)
plot(sim)

# The default plot title and axis labels can be changed like so:
plot(sim, main = "Simulated trajectory", xlab = "Time", ylab = "Value")

# Add constants to the plot
plot(sim, add_constants = TRUE)

}
\seealso{
\code{\link[=simulate]{simulate()}}, \code{\link[=as.data.frame.sdbuildR_sim]{as.data.frame.sdbuildR_sim()}}, \code{\link[=plot.sdbuildR_xmile]{plot.sdbuildR_xmile()}}
}
\concept{simulate}
