% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{tetris2015}
\alias{tetris2015}
\title{Tetris and intrusive memories}
\format{
A data frame with 72 rows and 28 variables:
\describe{
\item{Condition}{(factor) Condition: Control, Tetris_Reactivation, Tetris, or Reactivation}
\item{Time_of_Day}{Time of day participant commenced experiment, either "morning” or “afternoon”}
\item{BDI_II}{Beck Depression Inventory-II (BDI-II): Total score}
\item{STAI_T}{Spielberger State-Trait Anxiety Trait scale (STAI): Total score}
\item{pre_film_VAS_Sad}{Self-rated level of Sadness: Pre-film VAS mood. VAS = visual analogue scale. All VAS mood scales anchored from “not at all” to “extremely” in response to the question “Right at this very moment I am feeling”. Composite for pre-film mood calculated by summing the six pre-film VAS mood ratings}
\item{pre_film_VAS_Hopeless}{Self-rated level of Hopelessness: Pre-film VAS mood}
\item{pre_film_VAS_Depressed}{Self-rated level of Depressed: Pre-film VAS mood}
\item{pre_film_VAS_Fear}{Self-rated level of Fear: Pre-film VAS mood}
\item{pre_film_VAS_Horror}{Self-rated level of Horror: Pre-film VAS mood}
\item{pre_film_VAS_Anxious}{Self-rated level of Anxiousness: Pre-film VAS mood}
\item{post_film_VAS_Sad}{Self-rated level of Sadness: Post-film VAS mood. Composite for post-film mood calculated by summing the six post-film VAS mood ratings}
\item{post_film_VAS_Hopeless}{Self-rated level of Hopelessness: Post-film VAS mood}
\item{post_film_VAS_Depressed}{Self-rated level of Depressed: Post-film VAS mood}
\item{post_film_VAS_Fear}{Self-rated level of Fear: Post-film VAS mood}
\item{post_film_VAS_Horror}{Self-rated level of Horror: Post-film VAS mood}
\item{post_film_VAS_Anxious}{Self-rated level of Anxious: Post-film VAS mood}
\item{Attention_Paid_to_Film}{Attention paid to the film rating: How much attention did you pay to the film from 0-not at all to 10-extremely}
\item{Post_film_Distress}{Post film distress rating: How distressing did you find the film from 0-not at all to 10-extremely}
\item{Day_Zero_Number_of_Intrusions}{Day 0: Number of image-based intrusive memories in the Intrusion Diary (pre-intervention)}
\item{Days_One_to_Seven_Number_of_Intrusions}{Days 1-7: Number of image-based intrusive memories in the Intrusion Diary (post-intervention)}
\item{Visual_Recognition_Memory_Test}{Visual recognition memory test score: Number of correct responses (out of 22)}
\item{Verbal_Recognition_Memory_Test}{Verbal recognition memory test score: Number of correct responses (out of 32)}
\item{Number_of_Provocation_Task_Intrusions}{Intrusion Provocation Task (IPT):  Number of image-based intrusive memories during 2min laboratory task on Day 7}
\item{Diary_Compliance}{Diary compliance rating - indicate how accurate you think your diary is from 1 - not at all accurate to 10 extremely}
\item{IES_R_Intrusion_subscale}{Impact of Event Scale-Revised (IES-R): Intrusion Subscale}
\item{Tetris_Total_Score}{Tetris game play computer score total - cumulative (sum of all games). Only participants who played Tetris have data relating to Tetris_Total_Score}
\item{Self_Rated_Tetris_Performance}{Self-rated Tetris performance: How difficult or easy did you find the game you just played. Only participants who played Tetris have data relating to Self_Rated_Tetris_Performance.}
\item{Tetris_Demand_Rating}{Demand rating: How much did you think Tetris after a distressing film would increase or decrease intrusive memories of the film: -10: extremely decrease, to +10: extremely increase}
}
}
\source{
\url{https://osf.io/ideta/}. See also James et al., 'Computer Game Play Reduces Intrusive Memories of Experimental Trauma via Reconsolidation-Update Mechanisms'.
}
\usage{
tetris2015
}
\description{
Tetris and intrusive memories
}
\keyword{datasets}
