\name{rowChisq2Class}
\alias{rowChisq2Class}
\alias{rowChisqMultiClass}

\title{Rowwise Pearson's ChiSquare Test Based on Tables}
\description{
  Given a set of matrices, each of which represents one group of subjects, and
  summarizes rowwise the numbers of these observations
  showing the levels of the categorical variables represented by the rows of
  the matrices, the value of Pearson's ChiSquare statistic for testing
  whether the distribution of the variable differs between the different
  groups is computed for each variable.
  
  Using this function instead of \code{rowChisqStats} is recommended
  when the total number of observations is very large.
}
\usage{
rowChisq2Class(cases, controls, add.pval = TRUE, sameNull = FALSE)

rowChisqMultiClass(..., listTables = NULL, add.pval = TRUE,
   sameNull = FALSE)
}

\arguments{
  \item{cases}{a numeric matrix in which each row represents one categorical
     variable and each column one of the levels that the variables exhibit. The
     entries of this matrix are the numbers of observations from one group (e.g.,
     the cases in a case-control study) showing a particular
     level at the different variables. Such a matrix can, e.g., be generated
     by \code{\link{rowTables}}.The rowwise sums of \code{cases} are allowed to
     differ between variables (which might happen when some of the observations
     are missing for some of the variables).}
  \item{controls}{a numeric matrix of the same dimensions as \code{cases} comprising
     the numbers of observations from the second group (e.g., the controls in a
     case-control study) that show the respective level at the different variables.
     The rows of \code{controls} must represent the same variables in the same
     order as \code{cases}, and the columns must represent the same levels in the
     same order. This matrix can also be generated by employing \code{\link{rowTables}}.
     The rowwise sums of \code{controls} are allowed to
     differ between variables (which might happen when some of the observations
     are missing for some of the variables).}
  \item{...}{numeric matrices (such as \code{cases} and \code{controls}) each of which
     comprises the numbers of observations showing the respective levels at the different
     variables. The dimensions of all matrices must be the same, and the rows and columns
     must represent the same variables and levels, respectively, in the same order in
     all matrices.}
  \item{listTables}{instead of inputting the matrices directly into \code{rowChisqMultiClass}
     a list can generated, where each entry of this list is one of matrices, and this
     list can be used in \code{rowChisqMultiClass} by specifying \code{listTables}.}
  \item{add.pval}{should p-values be added to the output? If \code{FALSE}, only the
     rowwise values of Pearson's ChiSquare statistic will be returned. If \code{TRUE},
     additionally the degrees of freedom and the (raw) p-values are computed by assuming
     approximation to the ChiSquare-distribution, and added to the output.}
  \item{sameNull}{should all variables follow the same null distribution? If \code{TRUE},
     then all variables must show the same number of levels such that their null distribution
     is approximated by the same ChiSquare-distribution.}
}

\value{
  Either a vector containing the rowwise values of Pearson's ChiSquare statistic
  (if \code{add.pval = FALSE}) or a list containing these values (\code{stats}),
  the degrees of freedom (\code{df}), and the p-values (\code{rawp}) not adjusted
  for multiple comparisons (if \code{add.pval = TRUE}).
}

\author{Holger Schwender, \email{holger.schwender@udo.edu}}
\note{
  The usual contingency table for a variable can be obtained from the matrices
  by forming a variable-specific matrix in which each row consists of the
  row of one of these matrices.
}

\seealso{\code{\link{rowChisqStats}}, \code{\link{rowTables}}, \code{\link{rowCATTs}},
  \code{\link{rowMsquares}}}
\examples{\dontrun{
# Generate a matrix containing data for 10 categorical 
# variables with levels 1, 2, 3.

mat <- matrix(sample(3, 500, TRUE), 10)

# Now assume that the first 25 columns correspond to
# cases and the remaining 25 columns to cases. Then
# a vector containing the class labels is given by

cl <- rep(1:2, e=25)

# and the matrices summarizing the numbers of subjects
# showing the respective levels at the different variables
# are computed by

cases <- rowTables(mat[, cl==1])
controls <- rowTables(mat[,cl==2])

# To obtain the ChiSquare values call

rowChisq2Class(cases, controls)

# This leads to the same results as

rowChisqStats(mat, cl)

# or

rowChisqMultiClass(cases, controls)

# or

listTab <- list(cases, controls)
rowChisqMultiClass(listTables = listTab)

  }
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{htest}
\keyword{array}
