% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance.R
\name{racset}
\alias{racset}
\title{Randomize an acset}
\usage{
racset(acset, type = "ac", fixedrowmargin = FALSE)
}
\arguments{
\item{acset}{An acset list created by \code{\link{new_acset}}.}

\item{type}{A character string with two allowed values. 'ac' specifies that
the allele count matrixes should be randomized and 'gt' specifies that the
genotype matrix should be randomized.}

\item{fixedrowmargin}{Boolean specifying if the row-sums should be kept
unchanged.}
}
\value{
acset A randomized acset list.
}
\description{
\code{racset} randomizes the entries in the allele count matrixes or the
genotype matrix
}
\details{
The function scrambles all entries within each allele count matrix or within
the genotype matrix.
}
\examples{
##create a small artificial genotype matrix
ncells = 10
paternal = c(0, 2, 0, 0, 2)
maternal = c(2, 0, 2, 2, 0)
gt = as.matrix(as.data.frame(rep(list(paternal, maternal), ncells / 2)))
vars = 1:nrow(gt)
colnames(gt) = 1:ncells
rownames(gt) = vars

##create a feature annotation data-frame
nvars = nrow(gt)
featdata = as.data.frame(matrix(cbind(rep('jfeat', nvars),
as.character(1:nvars), rep('dummy', nvars), rep('dummy', nvars)), ncol = 4,
dimnames = list(vars, c('feat', 'var', 'ref', 'alt'))), stringsAsFactors =
FALSE)

##create acset
acset = new_acset(featdata, gt = gt)

##Randomize the genotype matrix
type = 'gt'
acset_rand = racset(acset, type)

}

