% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{score_heatmap}
\alias{score_heatmap}
\title{Create a Heatmap of a Scoring Metric}
\usage{
score_heatmap(scores, y = "model", x, metric, ylab = y, xlab = x)
}
\arguments{
\item{scores}{A data.frame of scores based on quantile forecasts as
produced by \code{\link{eval_forecasts}}.}

\item{y}{The variable from the scores you want to show on the y-Axis. The
default for this is "model"}

\item{x}{The variable from the scores you want to show on the x-Axis. This
could be something like "horizon", or "location"}

\item{metric}{the metric that determines the value and colour shown in the
tiles of the heatmap}

\item{ylab}{Label for the y-axis. Default is the variable name on the y-axis}

\item{xlab}{Label for the x-axis. Default is the variable name on the x-axis}
}
\value{
A ggplot2 object showing a heatmap of the desired metric
}
\description{
This function can be used to create a heatmap of one metric across different
groups, e.g. the interval score obtained by several forecasting models in
different locations.
}
\examples{
scores <- scoringutils::eval_forecasts(scoringutils::quantile_example_data_long,
                                       by = c("model", "id", "horizon"),
                                       summarise_by = c("model", "horizon"))

scoringutils::score_heatmap(scores, x = "horizon", metric = "bias")

}
