% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_hoc.R
\name{tukeyPost}
\alias{tukeyPost}
\title{Tukey post hoc test for ANOVA.}
\usage{
tukeyPost(data, control = NULL, ...)
}
\arguments{
\item{data}{Data set (matrix or data.frame) to apply the test. The column names are taken as the groups and the values in the matrix are the samples.}

\item{control}{Either the number or the name of the column for the control algorithm. If this parameter is not provided, the all vs all comparison is performed.}

\item{...}{Not used.}
}
\value{
A matrix with all the pairwise corrected p-values.
}
\description{
This function computes all the pairwise p-values corrected using Tukey post hoc test.
}
\details{
The test has been implemented according to Test 22 in Kanji (2006).
}
\examples{
data(data_gh_2008)
tukeyPost(data.gh.2008)
tukeyPost(data.gh.2008, control=1)
}
\references{
G. K. Kanji (2006) \emph{100 Statistical Tests}. SAGE Publications Ltd, 3rd edition.
}

