% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/loading_functions.R
\name{readComparisonDir}
\alias{readComparisonDir}
\title{Read data from a directory of comparison-like files}
\usage{
readComparisonDir(directory, alg.cols, names, fname.pattern, col.names = NULL,
  ...)
}
\arguments{
\item{directory}{Directory where the files are located.}

\item{alg.cols}{A vector column names or indices inicating which columns contain the results. The rest are assumed as descriptors of the problems}

\item{names}{List of names for the variables to be extracted from the file name.}

\item{fname.pattern}{Regular expression to extract information from the file names. It has to be a regular expression that matches the name of the files and where the information to be extrcted has to be between brakets. As an example, if the whole file name wants to be used, the expression \code{'([.]*)'} can be used. For more example see the examples below or the vignette covering the data loading.}

\item{col.names}{Vector of names of the columns. If not NULL, the files are assumed not to have a header and the columns are named using this vector.}

\item{...}{Additional parameters for the read.csv function used to load the data. It can be used, for example, to set the separator (e.g., \code{sep="\t"}). Note that the \code{header} argument is automatically set according to the \code{col.names} argument.}
}
\value{
A data.frame where each column represents either a feature of the experiment or the result of running an algorithm. Algorithm columns are placed always at the end of the table.
}
\description{
This function reads the data from all files in a directory. Each file is expected to to be formated as a comparison file, i.e., the file can have some columns that characterize the problem and one column per algorithm. If each row contain only the result obtained by one algorithm, use the \code{\link{readExperimentDir}} function.
}
\examples{
dir <- paste(system.file("loading_tests",package="scmamp") , "comparison_files" , sep="/")
# The format of the files is rgg_size_SIZE_r_RADIUS.out, where variables to extract are in
# capital letters.
list.files(dir)[1]
# The regular expresion can be as simple as substituting each variable name in the expression
# above by ([XXX]*), where XXX is the list of symbols that appear in the name.
pattern <- "rgg_size_([0-9]*)_r_(0.[0-9]*).out"
var.names <- c("Size", "Radius")
data <- readComparisonDir (directory=dir, alg.cols=1:8, names=var.names,
                           fname.pattern=pattern)
dim(data)
head(data)
}
\seealso{
\code{\link{readExperimentFile}}, \code{\link{readExperimentDir}}, \code{\link{readComparisonDir}} and the vignette \code{vignette(topic="Data_loading_and_manipulation", package="scmamp")}
}

