% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{two_titre_data}
\alias{two_titre_data}
\title{Simulated two-titre antibody data}
\format{A data frame with 5000 observations and 3 variables:

  \describe{

  \item{logHI}{haemagglutinin-inhibiting (HI) titre. True simulated titre on
  a log scale.}

  \item{logNI}{neuraminidase-inhibiting titre. True simulated titre on a log
  scale.}

  \item{status}{influenza infection status. 1 - infected. 0 - not infected} }}
\usage{
two_titre_data
}
\description{
A simulated dataset containing 5000 independent observations on antibody
titres and the corresponding infection status. The data was simulated to
resemble real influenza infection and haemagglutinin + neuraminidase titre
data.
}
\section{Model}{


  The model behind the simulation was

  \deqn{\lambda * (1 - f(\beta_0 + \beta_1 * HI + \beta_2 * NI))}

  Where

  \itemize{

  \item \eqn{f} - Inverse logit function

  \item \eqn{\lambda} = 0.5

  \item \eqn{\beta_0} = -7.5

  \item \eqn{\beta_1} = 2

  \item \eqn{\beta_2} = 2 }
}

\keyword{datasets}
