% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal.R
\name{.scidbeval}
\alias{.scidbeval}
\title{An important internal convenience function that returns a scidb object.  If
eval=TRUE, a new SciDB array is created the returned scidb object refers to
that.  Otherwise, the returned scidb object represents a SciDB array promise.}
\usage{
.scidbeval(db, expr, eval = FALSE, name, gc = TRUE, depend, schema, temp)
}
\arguments{
\item{db}{scidb connection object}

\item{expr}{(character) A SciDB expression or array name}

\item{eval}{(logical) If TRUE evaluate expression and assign to new SciDB array.
If FALSE, infer output schema but don't evaluate.}

\item{name}{(optional character) If supplied, name for stored array when eval=TRUE}

\item{gc}{(optional logical) If TRUE, tie SciDB object to  garbage collector.}

\item{depend}{(optional list) An optional list of other scidb objects
that this expression depends on (preventing their garbage collection
if other references to them go away).}

\item{schema}{(optional) used to create SciDB temp arrays
(requires scidb >= 14.8)}

\item{temp}{(optional) used to create SciDB temp arrays
(requires scidb >= 14.8)}
}
\value{
A \code{scidb} array object
}
\description{
An important internal convenience function that returns a scidb object.  If
eval=TRUE, a new SciDB array is created the returned scidb object refers to
that.  Otherwise, the returned scidb object represents a SciDB array promise.
}
\note{
Only AFL supported.
}
