% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PanglaoDB.R
\name{ParsePanglaoDB}
\alias{ParsePanglaoDB}
\title{Parse PanglaoDB Data.}
\usage{
ParsePanglaoDB(
  meta,
  cell.type = "All",
  include.gene = NA,
  exclude.gene = NA,
  merge = FALSE
)
}
\arguments{
\item{meta}{Metadata contains "SRA", "SRS", "Tissue", "Protocol", "Species", can be obtained with \code{ExtractPanglaoDBMeta}.}

\item{cell.type}{Extract samples with specified cell types. For samples without SRS (notused), this value can only be "All" or "None", or
these samples will be filtered. Obtain available values with \code{StatDBAttribute}, one or multiple value. Default: "All".}

\item{include.gene}{Include cells expressing the genes. Default: NA.}

\item{exclude.gene}{Exclude cells expressing the genes. Default: NA.}

\item{merge}{Logical value, whether to merge Seurat list. Default: FALSE.}
}
\value{
Seurat object (if \code{merge} is TRUE) or list of Seurat objects (if \code{merge} is FALSE).
}
\description{
Parse PanglaoDB Data.
}
\examples{
\dontrun{
hsa.meta <- ExtractPanglaoDBMeta(
  species = "Homo sapiens",
  protocol = c("Smart-seq2", "10x chromium"),
  show.cell.type = TRUE, cell.num = c(1000, 2000)
)
hsa.seu <- ParsePanglaoDB(hsa.meta, merge = TRUE)
}
}
