% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scf_median.R
\name{scf_median}
\alias{scf_median}
\title{Estimate the Population Median of a Continuous SCF Variable}
\usage{
scf_median(scf, var, by = NULL)
}
\arguments{
\item{scf}{A \code{scf_mi_survey} object created by \code{\link[=scf_load]{scf_load()}}. Must contain five implicates.}

\item{var}{A one-sided formula specifying the continuous variable of interest (e.g., \code{~networth}).}

\item{by}{Optional one-sided formula for a categorical grouping variable.}
}
\value{
A list of class \code{"scf_median"} with:
\describe{
\item{results}{A data frame with pooled medians, standard errors, and range across implicates.}
\item{imps}{A list of implicate-level results.}
\item{aux}{Variable and grouping metadata.}
}
}
\description{
Estimates the median (50th percentile) of a continuous SCF variable. Use this
operation to characterize a typical or average value.  In contrast to
\code{\link[=scf_mean]{scf_mean()}}, this function is both uninfluenced by, and insensitive to,
outliers.
}
\section{Implementation}{

This function wraps \code{\link[=scf_percentile]{scf_percentile()}} with \code{q = 0.5}. The user provides a
\code{scf_mi_survey} object and a one-sided formula indicating the variable of
interest. An optional grouping variable can be specified with a second
formula.  Output includes pooled medians, standard errors, min/max across
implicates, and implicate-level values.
}

\section{Statistical Notes}{

Median estimates are not pooled using Rubin’s Rules. Following SCF protocol,
the function calculates the median within each implicate and averages across implicates.
See the data set's official codebook.
}

\examples{
# Do not implement these lines in real analysis:
# Use functions `scf_download()` and `scf_load()`
td  <- tempdir()
src <- system.file("extdata", "scf2022_mock_raw.rds", package = "scf")
file.copy(src, file.path(td, "scf2022.rds"), overwrite = TRUE)
scf2022 <- scf_load(2022, data_directory = td)

# Example for real analysis: Estimate medians
scf_median(scf2022, ~networth)
scf_median(scf2022, ~networth, by = ~edcl)

# Do not implement these lines in real analysis: Cleanup for package check
unlink("scf2022.rds", force = TRUE)

}
\seealso{
\code{\link[=scf_percentile]{scf_percentile()}}, \code{\link[=scf_mean]{scf_mean()}}
}
