% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatter_points_rgbwt.R
\name{scatter_points_rgbwt}
\alias{scatter_points_rgbwt}
\title{scatter_points_rgbwt}
\usage{
scatter_points_rgbwt(
  xy,
  xlim = c(min(xy[, 1]), max(xy[, 1])),
  ylim = c(min(xy[, 2]), max(xy[, 2])),
  out_size = c(512, 512),
  RGBA = c(0, 0, 0, 255),
  map = NULL,
  palette = NULL
)
}
\arguments{
\item{xy}{2-column matrix with point coordinates. As usual with
rasters in R, X axis grows right, and Y axis grows DOWN.
Flipping \code{ylim} causes the "usual" mathematical behavior.}

\item{xlim}{Limits as usual (position of the first pixel on the
left/top, and the last pixel on the right/bottom), 2-element vector.
You can easily flip the top/bottom to the "usual" mathematical
system by flipping the \code{ylim} vector.}

\item{ylim}{Limits as usual (position of the first pixel on the
left/top, and the last pixel on the right/bottom), 2-element vector.
You can easily flip the top/bottom to the "usual" mathematical
system by flipping the \code{ylim} vector.}

\item{out_size}{2-element vector, size of the result histogram,
defaults to \code{c(512,512)}.}

\item{RGBA}{Vector with 4 elements or matrix or array (4xn dim, n >= 2, n ~ xy rows) with R, G, B
and alpha channels in integers, defaults to \code{c(0,0,0,255)}.}

\item{map}{Vector with integer indices to \code{palette}.}

\item{palette}{Matrix with R, G, B and A channels in rows, of at \code{maximum(map)} columns.}
}
\value{
An array in RGBWT format with the scatterplot output.
}
\description{
Colorize given data with one given color or each point has its corresponding given color.
}
