% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trend.R
\name{trend}
\alias{trend}
\alias{trendSC}
\title{Trend analysis for single-cases data}
\usage{
trend(data, dvar, pvar, mvar, offset = -1, model = NULL)

trendSC(...)
}
\arguments{
\item{data}{A single-case data frame. See \code{\link{scdf}} to learn about this format.}

\item{dvar}{Character string with the name of the dependent variable. Defaults to the attributes in the scdf file.}

\item{pvar}{Character string with the name of the phase variable. Defaults to the attributes in the scdf file.}

\item{mvar}{Character string with the name of the measurement time variable. Defaults to the attributes in the scdf file.}

\item{offset}{An offset for the first measurement-time of each phase (MT). If
\code{offset = 0}, the phase measurement is handled as MT 1.
Default is \code{offset = -1}, setting the first value of MT to 0.}

\item{model}{A string or a list of (named) strings each depicting one
regression model. This is a formula expression of the standard R class. The
parameters of the model are \code{values}, \code{mt} and \code{phase}.}

\item{...}{Further arguments passed to the function.}
}
\value{
\item{trend}{A matrix containing the results (Intercept, B and beta)
of separate regression models for phase A, phase B, and the whole data.}
\item{offset}{Numeric argument from function call (see \code{Arguments}
section).}
}
\description{
The \code{trend} function provides an overview of linear trends in
single-case data.  By default, it gives you the intercept and slope of a
linear and a squared regression of measurement-time on scores.  Models are
computed separately for each phase and across all phases. For a
more advanced application, you can add regression models using the R
specific formula class.
}
\examples{

## Compute the linear and squared regression for a random single-case
design <- design_rSC(slope = 0.5)
matthea <- rSC(design)
trend(matthea)

## Besides the linear and squared regression models compute two custom models:
## a) a cubic model, and b) the values predicted by the natural logarithm of the
## measurement time.
design <- design_rSC(slope = 0.3)
ben <- rSC(design)
trend(ben, offset = 0, model = c("Cubic" = values ~ I(mt^3), "Log Time" = values ~ log(mt)))

}
\seealso{
\code{\link{describe}}, \code{\link{autocorr}},
\code{\link{plm}}
}
\author{
Juergen Wilbert
}
