% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scDIFtest-Methods.R
\name{scDIFtest-Methods}
\alias{scDIFtest-Methods}
\alias{print.scDIFtest}
\alias{summary.scDIFtest}
\alias{plot.scDIFtest}
\title{Methods for the scDIFtest-class}
\usage{
\method{print}{scDIFtest}(x, item_selection = NULL, ...)

\method{summary}{scDIFtest}(object, method = "fdr", ...)

\method{plot}{scDIFtest}(x, item_selection = NULL, ...)
}
\arguments{
\item{x}{an object of class \code{scDIFtest}}

\item{item_selection}{either \code{NULL} or an integer vector selecting the
item numbers. When \code{items = NULL} (the default), the DIF test
is done for all items.}

\item{...}{other arguments passed to the method.}

\item{object}{an object of class \code{scDIFtest}}

\item{method}{one of the strings in \code{p.adjust.methods}.}
}
\description{
\code{print}, \code{summary}, and \code{plot} methods for objects of the
\code{scDIFtest-class}, as returned by \code{\link{scDIFtest}}. See details
for more information about the methods.
}
\details{
The \code{print} method, when\code{item_selection = NULL}, gives a summary
of all the tests that were executed (i.e., for all items). When specific
items are selected, the \code{print} method is called repeatedly for each
individual \code{sctest} corresponding with the selected items.

The \code{summary} method computes a data frame with a row for each item
that was included in the test. The columns are:
  \describe{
     \item{item_type}{The estimated IRT model per item}
     \item{n_est_pars}{The number of estimated parameters per item}
     \item{stat}{The value for the used statistic per item}
     \item{p_value}{The p-value per item}
     \item{p_fdr}{The corrected p-value controlling the false discovery rate
     (Benjamini & Hochberg, 1995). See \code{\link[stats]{p.adjust}} for
     details.}
   }

 The \code{plot} method call the \code{plot} method repeatedly for the
 \code{gepf} that corresponds with the executed score test for each of the
 selected items. When no items are selected, the \code{plot} method results
 in an error.
}
\references{
Benjamini, Y., and Hochberg, Y. (1995). Controlling the false
discovery rate: a practical and powerful approach to multiple testing.
\emph{Journal of the Royal Statistical Society Series B, 57,} 289-300.
}
