% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Seurat_Plotting.R
\name{Clustered_DotPlot}
\alias{Clustered_DotPlot}
\title{Clustered DotPlot}
\usage{
Clustered_DotPlot(
  seurat_object,
  features,
  colors_use_exp = viridis_plasma_dark_high,
  exp_color_min = -2,
  exp_color_middle = NULL,
  exp_color_max = 2,
  print_exp_quantiles = FALSE,
  colors_use_idents = NULL,
  x_lab_rotate = TRUE,
  flip = FALSE,
  k = 1,
  feature_km_repeats = 1000,
  ident_km_repeats = 1000,
  row_km_repeats = deprecated(),
  column_km_repeats = deprecated(),
  row_label_size = 8,
  raster = FALSE,
  plot_km_elbow = TRUE,
  elbow_kmax = NULL,
  assay = NULL,
  group.by = NULL,
  idents = NULL,
  show_parent_dend_line = TRUE,
  ggplot_default_colors = FALSE,
  color_seed = 123,
  seed = 123
)
}
\arguments{
\item{seurat_object}{Seurat object name.}

\item{features}{Features to plot.}

\item{colors_use_exp}{Color palette to use for plotting expression scale.  Default is \code{viridis::plasma(n = 20, direction = -1)}.}

\item{exp_color_min}{Minimum scaled average expression threshold (everything smaller will be set to this).
Default is -2.}

\item{exp_color_middle}{What scaled expression value to use for the middle of the provided \code{colors_use_exp}.
By default will be set to value in middle of \code{exp_color_min} and \code{exp_color_max}.}

\item{exp_color_max}{Minimum scaled average expression threshold (everything smaller will be set to this).
Default is 2.}

\item{print_exp_quantiles}{Whether to print the quantiles of expression data in addition to plots.
Default is FALSE.  NOTE: These values will be altered by choices of \code{exp_color_min} and \code{exp_color_min}
if there are values below or above those cutoffs, respectively.}

\item{colors_use_idents}{specify color palette to used for identity labels.  By default if
number of levels plotted is less than or equal to 36 it will use "polychrome" and if greater than 36
will use "varibow" with shuffle = TRUE both from \code{DiscretePalette_scCustomize}.}

\item{x_lab_rotate}{How to rotate column labels.  By default set to \code{TRUE} which rotates labels 45 degrees.
If set \code{FALSE} rotation is set to 0 degrees.  Users can also supply custom angle for text rotation.}

\item{flip}{logical, whether to flip the axes of final plot.  Default is FALSE; rows = features and
columns = idents.}

\item{k}{Value to use for k-means clustering on features  Sets (km) parameter in \code{ComplexHeatmap::Heatmap()}.
From \code{ComplexHeatmap::Heatmap()}: Apply k-means clustering on rows. If the value is larger than 1, the
heatmap will be split by rows according to the k-means clustering. For each row slice, hierarchical
clustering is still applied with parameters above.}

\item{feature_km_repeats}{Number of k-means runs to get a consensus k-means clustering for features.
Note if \code{feature_km_repeats} is set to value greater than one, the final number of groups might be
smaller than row_km, but this might mean the original row_km is not a good choice.  Default is 1000.}

\item{ident_km_repeats}{Number of k-means runs to get a consensus k-means clustering. Similar to
\code{feature_km_repeats}.  Default is 1000.}

\item{row_km_repeats}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} soft-deprecated.  See \code{feature_km_repeats}}

\item{column_km_repeats}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} soft-deprecated.  See \code{ident_km_repeats}}

\item{row_label_size}{Size of the feature labels.  Provided to \code{row_names_gp} in Heatmap call.}

\item{raster}{Logical, whether to render in raster format (faster plotting, smaller files).  Default is FALSE.}

\item{plot_km_elbow}{Logical, whether or not to return the Sum Squared Error Elbow Plot for k-means clustering.
Estimating elbow of this plot is one way to determine "optimal" value for \code{k}.
Based on: \url{https://stackoverflow.com/a/15376462/15568251}.}

\item{elbow_kmax}{The maximum value of k to use for \code{plot_km_elbow}.  Suggest setting larger value so the
true shape of plot can be observed.  Value must be 1 less than number of features provided.  If NULL parameter
will be set dependent on length of feature list up to \code{elbow_kmax = 20}.}

\item{assay}{Name of assay to use, defaults to the active assay.}

\item{group.by}{Group (color) cells in different ways (for example, orig.ident).}

\item{idents}{Which classes to include in the plot (default is all).}

\item{show_parent_dend_line}{Logical, Sets parameter of same name in \code{ComplexHeatmap::Heatmap()}.
From \code{ComplexHeatmap::Heatmap()}: When heatmap is split, whether to add a dashed line to mark parent
dendrogram and children dendrograms.  Default is TRUE.}

\item{ggplot_default_colors}{logical.  If \code{colors_use = NULL}, Whether or not to return plot using
default ggplot2 "hue" palette instead of default "polychrome" or "varibow" palettes.}

\item{color_seed}{random seed for the "varibow" palette shuffle if \code{colors_use = NULL} and number of
groups plotted is greater than 36.  Default = 123.}

\item{seed}{Sets seed for reproducible plotting (ComplexHeatmap plot).}
}
\value{
A ComplexHeatmap or if plot_km_elbow = TRUE a list containing ggplot2 object and ComplexHeatmap.
}
\description{
Clustered DotPlots using ComplexHeatmap
}
\examples{
\donttest{
library(Seurat)
Clustered_DotPlot(seurat_object = pbmc_small, features = c("CD3E", "CD8", "GZMB", "MS4A1"))
}

}
\references{
\url{https://divingintogeneticsandgenomics.rbind.io/post/clustered-dotplot-for-single-cell-rnaseq/}
}
\seealso{
\url{https://twitter.com/tangming2005}
}
\author{
Ming Tang (Original Code), Sam Marsh (Wrap single function, added/modified functionality)
}
\concept{seurat_plotting}
