% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbpiper_pe.r
\name{parameter_pca_analysis}
\alias{parameter_pca_analysis}
\title{PCA for the parameters. These plots rely on factoextra fviz functions.}
\usage{
parameter_pca_analysis(model, filename, plots_dir, best_fits_percent = 50,
  label.ind = "all", select.ind = NULL, repel.ind = TRUE,
  label.var = "all", select.var = NULL, repel.var = TRUE)
}
\arguments{
\item{model}{the model name}

\item{filename}{the filename containing the fits sequence}

\item{plots_dir}{the directory to save the generated plots}

\item{best_fits_percent}{the percent of best fits to analyse.}

\item{label.ind}{parameter `label` passed to factoextra::fviz_pca_ind(). Labels shown if <= 75 and select.ind is NULL.}

\item{select.ind}{parameter `select.ind` passed to factoextra::fviz_pca_ind().}

\item{repel.ind}{parameter `repel` passed to factoextra::fviz_pca_ind()}

\item{label.var}{parameter `label` passed to factoextra::fviz_pca_var().}

\item{select.var}{parameter `select.var` passed to factoextra::fviz_pca_var().}

\item{repel.var}{parameter `repel` passed to factoextra::fviz_pca_var() 
dir.create(file.path("pe_datasets"))
dir.create(file.path("pe_plots"))
data(insulin_receptor_best_fits)
write.table(insulin_receptor_best_fits,
            file=file.path("pe_datasets", "best_fits.csv"),
            row.names=FALSE)
# generate the global statistics for the parameter estimation
pe_ds_preproc(filename=file.path("pe_datasets", "best_fits.csv"),
              param.names=c('k1', 'k2', 'k3'),
              logspace=TRUE,
              all.fits=FALSE)
parameter_pca_analysis(model="ir_beta",
                       filename=file.path("pe_datasets", "best_fits_log10.csv"),
                       plots_dir="pe_plots",
                       best_fits_percent=50)}
}
\description{
PCA for the parameters. These plots rely on factoextra fviz functions.
}
