% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/satdad_Rfunctions.R
\name{graphsMapEmp}
\alias{graphsMapEmp}
\title{Empirical graphs drawn on geographical maps of the tail dependence structure.}
\usage{
graphsMapEmp(
  sample,
  k,
  which = "taildependograph",
  names = NULL,
  coord,
  region = NULL,
  select = NULL,
  thick.td = 5,
  thick.ec = 5,
  eps = 0.03
)
}
\arguments{
\item{sample}{A \code{(n times d)} matrix.}

\item{k}{An integer smaller or equal to \code{n}.}

\item{which}{A character string: \code{both}, \code{taildependograph} (the default) or \code{iecgraph}.}

\item{names}{A character vector for \code{sample} columns which replaces \code{as.character(1:d)} (the default ones).}

\item{coord}{Latitudes and Longitudes associated with \code{sample} columns associated to \code{region} map when \code{region} is furnished.}

\item{region}{A geographical region from \code{maps} package. The default value is NULL.}

\item{select}{If select is NULL (the default) all edges are plotted. If select is an integer between 1 and the number of possible pairs of components of sample, then only the select largest edges are plotted.}

\item{thick.td}{A numeric value for the maximal thickness of edges in \code{taildependograph}. Default value is 5.}

\item{thick.ec}{A numeric value for the maximal thickness of edges in \code{iecgraph}. Default value is 5.}

\item{eps}{A numerical graphical value fixing the distance between the plotted point and its names.  The default value is 0.03.}
}
\value{
It returns both (or one among) the empirical tail dependograph and the empirical inverse extremal coefficients graph on a geographical map of the  \code{sample}.

 The empirical tail dependograph on a geographical map represents the pairwise empirical  tail superset importance coefficients of the locations associated with \code{sample} columns, see  Mercadier, C. and Roustant, O. (2019).
 These indices are computed by the function \code{tsicEmp}.
 It measures how much a pair of components (included supersets of this pair of components) is involved in the asymptotic dependence of the sample.

 The empirical inverse extremal coefficients graph  on a geographical map represents empirical pairwise coefficients of the locations associated with \code{sample} columns that estimate \eqn{1-\ell(1_i,1_j,\bold{0})/2}.
}
\description{
Empirical tail dependograph and  Empirical inverse extremal coefficients graph drawn on geographical maps for the tail dependence structure of \code{sample} associated with threshold k.
}
\examples{

data(France)

## Figure 9 (a) of Mercadier  and Roustant (2019).
graphsMapEmp(France$ymt, k = 55,
 coord = France$coord,  region = 'France', select = 9)

## Figure 9 (b) of Mercadier  and Roustant (2019).
graphsMapEmp(France$ymt, k = 55,
 coord = France$coord,  region = 'France', select = 30)

## Figure 9 (c) of Mercadier  and Roustant (2019).
graphsMapEmp(France$ymt, k = 55,
 coord = France$coord,  region = 'France')

}
\references{
Mercadier, C. and Roustant, O. (2019)
The tail dependograph.
\emph{Extremes}, \bold{22}, 343--372.


Becker, R. A.,  Wilks, A. R. (Original S code),  Brownrigg, R. (R version),  Minka, T. P. and  Deckmyn A. (Enhancements).  (2022)
maps : Draw Geographical Maps.
\emph{R package version 3.4.1.}
}
\seealso{
\code{\link[satdad]{graphsEmp}}
}
\author{
Cécile Mercadier (\code{mercadier@math.univ-lyon1.fr})
}
