#' A SAR dataset describing the plants of the Kapingamarangi Atoll
#'
#' A sample dataset in the correct mmSAR2 format: contains the areas of a number
#' of islands in the Kapingamarangi Atoll, and the number of plant species recorded on each
#' island.
#'
#' @usage data(niering)
#' @format A list with two elements. The first element contains the name of the
#'   dataset. The second element contains a data frame with 2 columns and 32
#'   rows. Each row contains the area of an island (km2) in the Kapingamarangi
#'   Atoll (1st column) and the number of plants on that island (2nd column).
#' @source Niering, W.A. (1963). Terrestrial ecology of Kapingamarangi Atoll,
#'  Caroline Islands. Ecol. Monogr., 33, 131–160.
#' @examples
#' data(niering)
"niering"