% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/santaR_pvalue_dist.R
\name{santaR_pvalue_dist}
\alias{santaR_pvalue_dist}
\title{Evaluate difference in group trajectories based on the comparison of distance between group mean curves}
\usage{
santaR_pvalue_dist(SANTAObj, nPerm = 1000, nStep = 5000, alpha = 0.05)
}
\arguments{
\item{SANTAObj}{A fitted \emph{SANTAObj} as generated by \code{\link{santaR_fit}}.}

\item{nPerm}{(int) Number of permutations. Default 1000.}

\item{nStep}{(int) Number of steps employed for the calculation of the area between group mean curves. Default is 5000.}

\item{alpha}{(float) Confidence Interval on the permuted \emph{p}-value \emph{(0.05 for 95\% Confidence Interval)}. Default 0.05.}
}
\value{
A \emph{SANTAObj} with added \emph{p}-value dist and confidence interval on the \emph{p}-value.
}
\description{
Evaluate the difference in group trajectories by executing a t-test based on the comparison of distance between group mean curves. Individual group membership is repeatedly randomly permuted to generate new random groups and group mean curves, then employed to compute a \emph{Null} distribution of distance between goup mean curves. The distance between two group mean curves is defined as the area between both curves. The distance between the real group mean curves is then compared to this \emph{Null} distribution and a \emph{p}-value is computed.
\itemize{
  \item The Pearson correlation coefficient between the two group mean curves is calculated to detect highly correlated group shapes if required.
  \item The \emph{p}-value is calculated as \code{(b+1)/(nPerm+1)} as to not report a \emph{p}-value=0 (which would give problem with FDR correction) and reduce type I error.
  \item The \emph{p}-value will vary depending on the random sampling. Therefore a confidence interval can be constructed using Wilson's interval which presents good properties for small number of trials and probabilities close to 0 or 1.
}
}
\examples{
## 56 measurements, 8 subjects, 7 unique time-points
## Default parameter values decreased to ensure an execution < 2 seconds
Yi          <- acuteInflammation$data$var_3
ind         <- acuteInflammation$meta$ind
time        <- acuteInflammation$meta$time
group       <- acuteInflammation$meta$group
grouping    <- get_grouping(ind, group)
inputMatrix <- get_ind_time_matrix(Yi, ind, time)
SANTAObj    <- santaR_fit(inputMatrix, df=5, grouping=grouping, verbose=TRUE)
SANTAObj    <- santaR_pvalue_dist(SANTAObj, nPerm=100)

}
\seealso{
Comparison with constant model with \code{\link{santaR_pvalue_dist_within}}

Other Analysis: 
\code{\link{get_grouping}()},
\code{\link{get_ind_time_matrix}()},
\code{\link{santaR_CBand}()},
\code{\link{santaR_auto_fit}()},
\code{\link{santaR_auto_summary}()},
\code{\link{santaR_fit}()},
\code{\link{santaR_plot}()},
\code{\link{santaR_pvalue_fit}()},
\code{\link{santaR_start_GUI}()}
}
\concept{Analysis}
