% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df_search.R
\name{get_eigen_spline_matrix}
\alias{get_eigen_spline_matrix}
\title{Generate a Ind x Time + Var data.frame concatenating all variables from input variable}
\usage{
get_eigen_spline_matrix(inputData, ind, time, ncores = 0)
}
\arguments{
\item{inputData}{\code{data.frame} of measurements with observations as rows and variables as columns}

\item{ind}{Vector of subject identifier (individual) corresponding to each measurement}

\item{time}{Vector of time corresponding to each measurement}

\item{ncores}{(int) Number of cores to use for parallelisation. Default 0 for no parallelisation.}
}
\value{
\code{data.frame} of measurements for each IND x TIME + VAR. Rows are unique Individual IDs per variable, and columns unique measurement Time. Pairs of (IND,TIME+VAR) without a measurement are left as NA.
}
\description{
Generate Ind x Time \code{data.frame} for each variable using \code{\link{get_ind_time_matrix}} and then concatenate all variables rowise. Resulting \code{data.frame} contrain Time as columns and Individuals and Variables as rows. Pairs of Individual and Timepoint without a measurement are left as NA. If ncore!=0 the function is parallelised, however the parallelisation overhead cost is high if not required.
}
\examples{
\dontrun{
## 6 measurements, 3 subjects, 3 unique time-points, 2 variables
inputData <- matrix(c(1,2,3,4,5,6, 7,8,9,10,11,12), ncol=2)
ind  <- c('ind_1','ind_1','ind_1','ind_2','ind_2','ind_3')
time <- c(0,5,10,0,10,5)
get_eigen_spline_matrix(inputData, ind, time, ncores=0)
#     0   5  10
# 1   1   2   3
# 2   4  NA   5
# 3  NA   6  NA
# 4   7   8   9
# 5  10  NA  11
# 6  NA  12  NA
}
}
