% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplers.R
\name{plot_2d_density}
\alias{plot_2d_density}
\title{Density Plotter}
\usage{
plot_2d_density(
  start,
  size,
  cellsPerRow = 50,
  names = NULL,
  params = NULL,
  weights = NULL,
  customDensity = NULL,
  plot = TRUE
)
}
\arguments{
\item{start}{Vector c(x, y) with the coordinates of the bottom-left corner of the map.}

\item{size}{Distance covered by the map. In other words, the top-right corner of the map has coordinates c(x + size, y + size)}

\item{cellsPerRow}{Number of cells to plot in every row. The higher, the more resolution}

\item{names}{Name of the distribution from which to sample from.}

\item{params}{Distribution parameters.}

\item{weights}{Distribution weights (if it's a mix of distributions)}

\item{customDensity}{Instead of providing names, params and weights, the user may prefer to provide a custom density function.}

\item{plot}{Whether to return a plot or a dataframe with the density in each coordinate}
}
\value{
Density Plot or dataframe
}
\description{
Plots a 2D map of the density of a distribution. If plot = FALSE, returns a dataframe with the density for each cell in the grid
}
\examples{
# plot supported distribution
plot_2d_density(
c(-5, -5), 10, cellsPerRow = 100, names = c("mvnorm", "mvnorm"),
params = list(list(c(-2,1), diag(2)), list(c(2,1), diag(2)))
)

# plot custom distribution
customDensity_r <- function(x){
    if (x[1] > 0 && x[1] < 3 && x[2] < 0 && x[2] > -3){
        return (1)
    } else {
        return (0)
    }
}
plot_2d_density(start = c(0,-4), size = 5, customDensity = customDensity_r)


}
