% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_functions.R
\name{calc_sigma_scaling}
\alias{calc_sigma_scaling}
\title{Sigma Scaling Calculator}
\usage{
calc_sigma_scaling(chain, plot = FALSE)
}
\arguments{
\item{chain}{Vector of n length, where n is the number of trials or sampler iterations}

\item{plot}{Boolean. Whether to additionally plot the result.}
}
\value{
A list containing the vector of possible lags, the sd of the distances at each lag, their log10 counterparts, and the calculated intercept and slope.
}
\description{
Calculates the sigma scaling of the chain, and optionally plots the result.
}
\details{
Sigma scaling is defined as the slope of the regression connecting log time lags and the standard deviation of value changes across time lags. Markets show values of 0.5.
}
\examples{

set.seed(1)
chain1 <- sampler_mh(1, "norm", c(0,1), diag(1))
calc_sigma_scaling(chain1[[1]], plot = TRUE)

}
