% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_simulations.R
\name{simul.saemix}
\alias{simul.saemix}
\title{Perform simulations under the model}
\usage{
simul.saemix(saemixObject, nsim = saemixObject["options"]$nb.sim,
  predictions = TRUE, res.var = TRUE, uncertainty = FALSE)
}
\arguments{
\item{saemixObject}{an object returned by the \code{\link{saemix}} function}

\item{nsim}{Number of simulations to perform. Defaults to the nb.simpred
element in options}

\item{predictions}{Whether the simulated parameters should be used to
compute predictions. Defaults to TRUE}

\item{res.var}{Whether residual variability should be added to the
predictions. Defaults to TRUE}

\item{uncertainty}{Uses uncertainty (currently not implemented). Defaults to
FALSE}
}
\description{
This function is used to simulate from the model. It can be called with the
estimated parameters (the default), the initial parameters, or with a set of
parameters. The original design can be used in the simulations, or a
different dataset may be used with the same structure (covariates) as the
original design. This function is not yet implemented.
}
\details{
This function is used to produce Visual Predictive Check graphs, as well as
to compute the normalised prediction distribution errors (npde).
}
\references{
Brendel, K, Comets, E, Laffont, C, Laveille, C, Mentre, F.
Metrics for external model evaluation with an application to the population
pharmacokinetics of gliclazide, Pharmaceutical Research 23 (2006),
2036-2049.

Holford, N. The Visual Predictive Check: superiority to standard diagnostic
(Rorschach) plots (Abstract 738), in: 14th Meeting of the Population
Approach Group in Europe, Pamplona, Spain, 2005.
}
\seealso{
\code{\link{SaemixObject}},\code{\link{saemix}},
\code{\link{saemix.plot.data}}, \code{\link{saemix.plot.convergence}},
\code{\link{saemix.plot.llis}}, \code{\link{saemix.plot.randeff}},
\code{\link{saemix.plot.obsvspred}}, \code{\link{saemix.plot.fits}},
\code{\link{saemix.plot.parcov}}, \code{\link{saemix.plot.distpsi}},
\code{\link{saemix.plot.scatterresiduals}}, \code{\link{saemix.plot.vpc}}
}
\author{
Emmanuelle Comets <emmanuelle.comets@inserm.fr>, Audrey Lavenu,
Marc Lavielle.
}
\keyword{model}
