% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Normal.R
\name{Normal}
\alias{Normal}
\title{Small Area Estimation using Hierarchical Bayesian under Normal Distribution}
\usage{
Normal(
  formula,
  vardir,
  iter.update = 3,
  iter.mcmc = 2000,
  thin = 1,
  burn.in = 1000,
  data
)
}
\arguments{
\item{formula}{Formula that describe the fitted model}

\item{vardir}{Sampling variances of direct estimations}

\item{iter.update}{Number of updates with default \code{3}}

\item{iter.mcmc}{Number of total iterations per chain with default \code{2000}}

\item{thin}{Thinning rate, must be a positive integer with default \code{1}}

\item{burn.in}{Number of iterations to discard at the begining with default \code{1000}}

\item{data}{The data frame}
}
\value{
This function returns a list of the following objects:
   \item{Est}{A vector with the values of Small Area mean Estimates using Hierarchical bayesian method }
   \item{sd}{A vector with the values of Standard deviation of Small Area Mean Estimates using Hierarchical bayesian method}
   \item{refVar}{Estimated random effect variances}
   \item{coefficient}{A dataframe with the estimated model coefficient}
   \item{plot}{Trace, Dencity, Autocorrelation Function Plot of MCMC samples}
}
\description{
This function is implemented to variable of interest \eqn{(y)} that assumed to be a Normal Distribution. The range of data is \eqn{(-\infty < y < \infty)}.
}
\examples{

#Compute Fitted Model
#y ~ x1 +x2 +x3


## For data without any nonsampled area
##Load Dataset
data(dataNormal)

saeHBnormal<-Normal(formula=y~x1+x2+x3,iter.update=1,vardir ="vardir",data=dataNormal )
saeHBnormal$Est                                 #Small Area mean Estimates
saeHBnormal$sd                                  #Standard deviation of Small Area Mean Estimates
saeHBnormal$refVar                              #refVar
saeHBnormal$coefficient                         #coefficient
#Load Library 'coda' to execute the plot
#autocorr.plot(saeHBnormal$plot[[3]]) is used to gerate ACF Plot
#plot(saeHBnormal$plot[[3]]) is used to generate Dencity and trace plot


## For data with nonsampled area use dataNormalNs


}
