% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZinbHB.R
\name{ZinbHB}
\alias{ZinbHB}
\title{Small Area Estimation using Hierarchical Bayesian under Zero Inflated Negative Binomial Distribution}
\usage{
ZinbHB(
  formula,
  iter.update = 3,
  iter.mcmc = 1100,
  coef.nonzero,
  coef.zero,
  var.coef.nonzero,
  var.coef.zero,
  thin = 1,
  burn.in = 600,
  tau.u = 1,
  tau.v = 1,
  data
)
}
\arguments{
\item{formula}{Formula that describe the fitted model}

\item{iter.update}{Number of updates with default \code{3}}

\item{iter.mcmc}{Number of total iterations per chain with default \code{1100}}

\item{coef.nonzero}{Optional vector containing initial values \code{mu.b} for the mean of the prior distribution of the log model coefficients \eqn{(\beta)} with default \code{rep(0,nvar)}}

\item{coef.zero}{Optional vector containing initial values \code{mu.g} for the mean of the prior distribution of the logit model coefficients \eqn{(\gamma)} with default \code{rep(0,nvar)}}

\item{var.coef.nonzero}{Optional vector containing initial values \code{tau.b} for the variance of the prior distribution on the log model coefficients \eqn{(\beta)} with default \code{rep(1,nvar)}}

\item{var.coef.zero}{Optional vector containing initial values \code{tau.g} for the variance of the prior distribution of the logit model coefficients \eqn{(\gamma)} with default \code{rep(1,nvar)}}

\item{thin}{Thinning rate, must be a positive integer with default \code{1}}

\item{burn.in}{Number of iterations to discard at the beginning with default \code{600}}

\item{tau.u}{Variance of random effect area for non-zero count of variable interest with default \code{1}}

\item{tau.v}{Variance of random effect area for zero count of variable interest with default \code{1}}

\item{data}{The data frame}
}
\value{
This function returns a list of the following objects:
   \item{Est}{A dataframe that contains the values, standar deviation, and quantile of Small Area mean Estimates using Hierarchical bayesian method}
   \item{refVar}{Estimated random effect variances}
   \item{coefficient}{A data frame with the estimated model coefficient consist of \code{beta} (coefficient in the log model) and \code{gamma} (coefficient in the logit model)}
   \item{plot.beta}{Trace, Density, Autocorrelation Function Plot of MCMC samples \code{beta}}
   \item{plot.gamma}{Trace, Density, Autocorrelation Function Plot of MCMC samples \code{gamma}}
}
\description{
This function is implemented to variable of interest \eqn{(y)} that assumed to be a Zero Inflated Negative Binomial Distribution. The range of data is \eqn{(y >= 0)}. This model can be used to handle overdispersion and excess zero in data.
}
\examples{
## Compute Fitted Model
## y ~ x1 +x2, nvar = 3

## For data without any nonsampled area
## Load Dataset
data(dataZINB)
result <- ZinbHB(formula = y ~ x1 + x2, data = dataZINB)

## Result
result$Est                             # Small Area mean Estimates
result$refVar                          # refVar
result$coefficient                     # coefficient


# Load library 'coda' to execute the plot
# autocorr.plot(result$plot.beta[[3]])  # Generate ACF Plot beta
# plot(result$plot.beta[[3]])           # Generate Dencity and Trace plot beta
# autocorr.plot(result$plot.gamma[[3]]) # Generate ACF Plot gamma
# plot(result$plot.gamma[[3]])          # Generate Dencity and trace plot gamma


## For data with nonsampled area use dataZINBNS


}
