% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asRxui.R
\name{as.rxUi}
\alias{as.rxUi}
\alias{as.rxUi.rxode2}
\alias{as.rxUi.rxModelVars}
\alias{as.rxUi.function}
\alias{as.rxUi.rxUi}
\alias{as.rxUi.default}
\title{As rxode2 ui}
\usage{
as.rxUi(x)

\method{as.rxUi}{rxode2}(x)

\method{as.rxUi}{rxModelVars}(x)

\method{as.rxUi}{`function`}(x)

\method{as.rxUi}{rxUi}(x)

\method{as.rxUi}{default}(x)
}
\arguments{
\item{x}{Object to convert to \code{rxUi} object}
}
\value{
rxUi object (or error if it cannot be converted)
}
\description{
As rxode2 ui
}
\examples{

mod1 <- function() {
 ini({
   # central 
   KA=2.94E-01
   CL=1.86E+01
   V2=4.02E+01
   # peripheral
   Q=1.05E+01
   V3=2.97E+02
   # effects
   Kin=1
   Kout=1
   EC50=200 
 })
 model({
   C2 <- centr/V2
   C3 <- peri/V3
   d/dt(depot) <- -KA*depot
   d/dt(centr) <- KA*depot - CL*C2 - Q*C2 + Q*C3
   d/dt(peri)  <- Q*C2 - Q*C3
   eff(0) <- 1
   d/dt(eff)   <- Kin - Kout*(1-C2/(EC50+C2))*eff
 })
}

as.rxUi(mod1)

}
\author{
Matthew L. Fidler
}
