% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tide.R
\name{rawtide}
\alias{rawtide}
\title{Raw Tidal data with data every 5 minutes for US locations
Tidal information only available for US cities.  Units are in feet.}
\usage{
rawtide(location, key = get_api_key(), raw = FALSE, message = TRUE)
}
\arguments{
\item{location}{location set by set_location}

\item{key}{weather underground API key}

\item{raw}{if TRUE return raw httr object}

\item{message}{if TRUE print out requested URL}
}
\value{
tbl_df with time (epoch) and height
}
\description{
Raw Tidal data with data every 5 minutes for US locations
Tidal information only available for US cities.  Units are in feet.
}
\examples{
\dontrun{
rawtide(set_location(territory = "Hawaii", city = "Honolulu"))
rawtide(set_location(territory = "Washington", city = "Seattle"))
rawtide(set_location(territory = "Louisiana", city = "New Orleans"))
}
}
