% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dml_docx.R
\name{dml_docx}
\alias{dml_docx}
\title{DrawingML graphic device for Microsoft Word}
\usage{
dml_docx(file = "Rplots.dml", width = 6, height = 6, bg = "white",
  fonts = list(), pointsize = 12, editable = TRUE, id = 1L,
  next_rels_id = 1L, raster_prefix = "raster_", standalone = TRUE,
  fontname_serif = NULL, fontname_sans = NULL, fontname_mono = NULL,
  fontname_symbol = NULL)
}
\arguments{
\item{file}{DrawingML file.}

\item{height, width}{Height and width in inches.}

\item{bg}{Default background color for the plot (defaults to "white").}

\item{fonts}{Named list of font names to be aliased with
fonts installed on your system. If unspecified, the R default
families \code{sans}, \code{serif}, \code{mono} and \code{symbol}
are aliased to the family returned by \code{\link[gdtools]{match_family}()}.}

\item{pointsize}{default point size.}

\item{editable}{should vector graphics elements (points, text, etc.)
be editable.}

\item{id}{specifies a unique identifier (integer) within the document
that will contain the DrawingML instructions.}

\item{next_rels_id}{specifies the next unique identifier (integer)
within relationship file that will be used to reference embedded
raster images if any.}

\item{raster_prefix}{string value used as prefix for png
files produced when raster objects are printed on the
graphical device.}

\item{standalone}{produce a standalone drawingml file? If \code{FALSE}, omits
xml header and namespaces.}

\item{fontname_serif, fontname_sans, fontname_mono, fontname_symbol}{font
names for font faces. Used fonts should be available in the operating system.
These arguments are deprecated in favor of the \code{fonts} argument.}
}
\description{
Graphics devices for Microsoft Word DrawingML format.
}
\examples{
dml_docx( file = tempfile() )
plot(1:11,(-5:5)^2, type='b', main="Simple Example")
dev.off()
}
\seealso{
\code{\link{Devices}}, \code{\link{dml_docx}}, \code{\link{dsvg}}
}
\keyword{device}

