% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvMF.R
\name{rvMF}
\alias{rvMF}
\title{von Mises-Fisher Distributed Pseudo-Random Vector Generator}
\usage{
rvMF(n, mu, k)
}
\arguments{
\item{n}{number of pseudo-random vectors to generate.}

\item{mu}{mean direction.}

\item{k}{concentration parameter. \eqn{k\ge 0}.}
}
\value{
matrix where each row independently follows the specified von
Mises-Fisher distribution. The number of columns equals the length of \code{mu},
and the number of rows equals \code{n} for \code{rvMF}.
}
\description{
\code{rvMF()} generates von-Mises Fisher distributed pseudo-random vectors,
without resorting to the rejection-based sampling method proposed by Wood
(1994). This function partly uses the code from the function \code{\link[Rfast:rvmf]{Rfast::rvmf()}}
and the article Marsaglia et al. (2004).
}
\examples{
rvMF(1e5, c(0,0,1), 10)
rvMF(1e4, c(1,1)/sqrt(2), 0)
}
\references{
K. V. Mardia and P. E. Jupp. Directional Statistics, volume 494. John Wiley
& Sons, Chichester, 1999.

G. Marsaglia, W. W. Tsang, and J. Wang. Fast generation of discrete random
variables. Journal of Statistical Software, 11(3):1–11, 2004.

M. Papadakis, M. Tsagris, M. Dimitriadis, S. Fafalios, I. Tsamardinos, M.
Fasiolo, G. Borboudakis, J. Burkardt, C. Zou, K. Lakiotaki, and C.
Chatzipantsiou. Rfast: A Collection of Efficient and Extremely Fast R
Functions, 2022. \url{https://CRAN.R-project.org/package=Rfast}. R package
version 2.0.6.

A. T. Wood. Simulation of the von Mises Fisher distribution. Communications
in Statistics– Simulation and Computation, 23(1):157–164, 1994.
}
\seealso{
\code{\link[=rvMFangle]{rvMFangle()}}, \code{\link[=dvMFangle]{dvMFangle()}}, \code{\link[Rfast:rvmf]{Rfast::rvmf()}}.
}
