% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exposure.R
\name{exposure}
\alias{exposure}
\alias{is_exposure}
\alias{get_exposure}
\alias{remove_exposure}
\title{Exposure}
\usage{
is_exposure(.x)

get_exposure(.object)

remove_exposure(.object)
}
\arguments{
\item{.x}{Object to test.}

\item{.object}{Object to get or remove \code{exposure} attribute from.}
}
\value{
\code{get_exposure()} returns \code{object} if it is exposure and its attribute
'exposure' otherwise.

\code{remove_exposure()} returns \code{object} with removed attributed 'exposure'.
}
\description{
Exposure is a result of \link[=expose]{exposing} data to rules. It is
implemented with S3 class \code{exposure} which is a list of the following
structure: \code{packs_info} - a \link{packs_info} object; \code{report} -
\link[=ruler-report]{tidy data validation report}.
}
\examples{
my_col_packs <- col_packs(
  col_sum_props = . \%>\% dplyr::summarise_all(
    rules(
      col_sum_low = sum(.) > 100,
      col_sum_high = sum(.) < 1000
    )
  )
)
mtcars_exposed <- mtcars \%>\% expose(my_col_packs)
mtcars_exposure <- mtcars_exposed \%>\% get_exposure()

is_exposure(mtcars_exposure)

identical(remove_exposure(mtcars_exposed), mtcars)

identical(get_exposure(mtcars_exposure), mtcars_exposure)
}
