% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_muted.R
\name{user_muted}
\alias{user_muted}
\title{List muted users}
\usage{
user_muted(
  ids,
  n = 1000,
  expansions = NULL,
  fields = NULL,
  ...,
  token = NULL,
  parse = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{ids}{A list id.}

\item{n}{Number of users to query.}

\item{expansions}{Set \code{NULL} to not use any expansion, set \code{NA} to get all
expansions, or provide a vector with the expansions you want (create it with
\code{\link[=set_expansions]{set_expansions()}}).}

\item{fields}{Set \code{NULL} to not use any field, get all allowed fields with \code{NA},
provide a list with the fields you want (create it with \code{\link[=set_fields]{set_fields()}}).}

\item{...}{Other parameters passed to the body of the request.}

\item{token}{These endpoints only accept a bearer token (can be created via
\code{\link[=rtweet_app]{rtweet_app()}}). In most cases you
are better of changing the default for all calls via \code{\link[=auth_as]{auth_as()}}.}

\item{parse}{If \code{TRUE}, the default, returns a tidy data frame. Use \code{FALSE}
to return the "raw" list corresponding to the JSON returned from the
Twitter API.}

\item{verbose}{A logical value to provide more information about paginated queries.}
}
\value{
A data.frame with the user information of who is following the list:
id, name, and username.
Other information depends on the \code{expansions} and \code{fields} requested.
Accepted values are:
\itemize{
\item Expansions: \code{set_expansions(tweet = NULL, list = NULL)}.
\item Fields: \code{set_fields(media = NULL, poll = NULL, place = NULL, list = NULL)}.
}
}
\description{
Looks up the muted users.
}
\examples{
if (FALSE) {
  um <- user_muted(user_self()$id)
}
}
\references{
\url{https://developer.twitter.com/en/docs/twitter-api/users/mutes/api-reference/get-users-muting}
}
\seealso{
\code{\link[=user_self]{user_self()}}
}
